/*+++++++++++++++++++++++++++++++++++++++++++*/
/* PROG TEST - SANS NOM1          Hiver 2001 */
/*            par Daniel Bienvenu            */
/*+++++++++++++++++++++++++++++++++++++++++++*/

#include <coleco.h>
#include <getput.h>

#define chrgen  0x0000
#define coltab  0x2000
#define chrtab  0x1800

extern byte NAME[];
extern byte PATTERN[];
extern byte COLOR[];

void nmi()
{
 update_sound();
}

static void init_vdp (void)
{

 byte j;
 int colpos;
 byte col;

 colpos = coltab;

 /* turn display off */
 screen_off ();
 /* disable NMI */
 disable_nmi ();
 /* clear VRAM */
 fill_vram (0,0,0x4000);

 put_vram (chrgen,PATTERN,0x800);
 put_vram (chrtab,NAME, 0x300);

 for (j=0;j<32;j++)
 {
  col = COLOR[j];
  fill_vram (colpos,col,64);
  colpos = colpos + 64;
 } 

 clear_sprites (0,64);
 /* Black screen border */
 vdp_out (7,0xf1);
 /* turn display on */
 screen_on ();
 /* enable NMI */
 enable_nmi ();
}

void main()
{
 init_vdp();
loop:
 goto loop;
}